﻿
/****************************************************************************/
/*Copyright (c) 2011, Florent DEVILLE.                                      */
/*All rights reserved.                                                      */
/*                                                                          */
/*Redistribution and use in source and binary forms, with or without        */
/*modification, are permitted provided that the following conditions        */
/*are met:                                                                  */
/*                                                                          */
/* - Redistributions of source code must retain the above copyright         */
/*notice, this list of conditions and the following disclaimer.             */
/* - Redistributions in binary form must reproduce the above                */
/*copyright notice, this list of conditions and the following               */
/*disclaimer in the documentation and/or other materials provided           */
/*with the distribution.                                                    */
/* - The names of its contributors cannot be used to endorse or promote     */
/*products derived from this software without specific prior written        */
/*permission.                                                               */
/* - The source code cannot be used for commercial purposes without         */
/*its contributors' permission.                                             */
/*                                                                          */
/*THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS       */
/*"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT         */
/*LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS         */
/*FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE            */
/*COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,       */
/*INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,      */
/*BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;          */
/*LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER          */
/*CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT        */
/*LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN         */
/*ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE           */
/*POSSIBILITY OF SUCH DAMAGE.                                               */
/****************************************************************************/

using GE.Visualisation;
using GE.Physics.Shapes;
using Microsoft.Xna.Framework;

namespace GE.World.Entities
{
    class LadderEntity : WorldEntity
    {
        /// <summary>
        /// Static rectangle
        /// </summary>
        StaticShapeRectangle _physicShape;

        /// <summary>
        /// Minimum position on the x axis to climb that ladder
        /// </summary>
        int _iPositionXMin;

        /// <summary>
        /// Maximum position on the x axis to climb the ladder
        /// </summary>
        int _iPositionXMax;

        /// <summary>
        /// Position the player gotta be set to to climb the ladder correctly
        /// </summary>
        int _iPositionX;

        /// <summary>
        /// Maximum height of the ladder
        /// </summary>
        int _iHeightMax;

        /// <summary>
        /// Minimum height of the ladder
        /// </summary>
        int _iHeightMin;

        public int PositionXMin { get { return _iPositionXMin; } }
        public int PositionXMax { get { return _iPositionXMax; } }
        public int PositionX { get { return _iPositionX; } }

        /// <summary>
        /// Return the bottom of the ladder
        /// </summary>
        public int HeightMax { get { return _iHeightMax; } }

        /// <summary>
        /// Return the top of the ladder
        /// </summary>
        public int HeightMin { get { return _iHeightMin; } }

        /// <summary>
        /// Constructor
        /// </summary>
        public LadderEntity() : base()
        {
            _entityType = eEntityType.eEntityPlatform;
        }

        public void activate(Rectangle rec)
        {

            
            _physicShape = Physics.Physics.Instance.createStaticRectangle(rec.Width, rec.Height, Vector2.Zero, new Vector2(rec.X, rec.Y), 0, this);
            _physicShape._iGroup = (int)ePhysicGroup.ePhysicLadder;

            _bActive = true;

            _iPositionXMin = rec.X;//(int)position.X;
            _iPositionXMax = rec.X + rec.Width;//_iPositionXMin + Visu.Instance.getSpriteWidth(_iIdTexture, _iIdSprite);
            _iPositionX = (int)((_iPositionXMax + _iPositionXMin) * 0.5f);

            _iHeightMin = rec.Y - 30;//(int)position.Y - 30; //should be the character height /2
            _iHeightMax = rec.Y + rec.Height - 33;//(int)position.Y + Visu.Instance.getSpriteHeight(_iIdTexture, _iIdSprite) - 33; //should be the character height
        }

        public override void update()
        {
            //throw new System.NotImplementedException();
        }

        public override void render()
        {
            //throw new System.NotImplementedException();
            //Visu.Instance.displaySprite(_iIdTexture, _iIdSprite, ScreenPosition);

#if DEBUG

            Vector2[] obb = new Vector2[4];
            System.Array.Copy(_physicShape.getOrientedBoundingBox(), obb, 4);
            for (int i = 0; i < 4; i++)
                obb[i] -= World.Instance.CameraPosition;

            Visu.Instance.displayPolygon(obb);
#endif
        }

        public override void die()
        {
            //throw new System.NotImplementedException();
        }
    }
}
